"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.FulfillmentEvent = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const country_1 = require("./country");
const province_1 = require("./province");
class FulfillmentEvent extends base_1.Base {
    static getJsonBodyName() {
        return "event";
    }
    static async find({ session, id, order_id = null, fulfillment_id = null, event_id = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id, "order_id": order_id, "fulfillment_id": fulfillment_id },
            params: { "event_id": event_id },
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id, order_id = null, fulfillment_id = null }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id, "order_id": order_id, "fulfillment_id": fulfillment_id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, order_id = null, fulfillment_id = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "order_id": order_id, "fulfillment_id": fulfillment_id },
            params: { ...otherArgs },
        });
        return response;
    }
}
exports.FulfillmentEvent = FulfillmentEvent;
FulfillmentEvent.apiVersion = types_1.ApiVersion.July23;
FulfillmentEvent.hasOne = {
    "country": country_1.Country,
    "province": province_1.Province
};
FulfillmentEvent.hasMany = {};
FulfillmentEvent.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["order_id", "fulfillment_id", "id"], "path": "orders/<order_id>/fulfillments/<fulfillment_id>/events/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": ["order_id", "fulfillment_id"], "path": "orders/<order_id>/fulfillments/<fulfillment_id>/events.json" },
    { "http_method": "get", "operation": "get", "ids": ["order_id", "fulfillment_id", "id"], "path": "orders/<order_id>/fulfillments/<fulfillment_id>/events/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": ["order_id", "fulfillment_id"], "path": "orders/<order_id>/fulfillments/<fulfillment_id>/events.json" }
];
FulfillmentEvent.resourceNames = [
    {
        "singular": "fulfillment_event",
        "plural": "fulfillment_events"
    }
];
//# sourceMappingURL=fulfillment_event.js.map