"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.InventoryItem = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class InventoryItem extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, ids = null, limit = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "ids": ids, "limit": limit, ...otherArgs },
        });
        return response;
    }
}
exports.InventoryItem = InventoryItem;
InventoryItem.apiVersion = types_1.ApiVersion.July23;
InventoryItem.hasOne = {};
InventoryItem.hasMany = {};
InventoryItem.paths = [
    { "http_method": "get", "operation": "get", "ids": [], "path": "inventory_items.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "inventory_items/<id>.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "inventory_items/<id>.json" }
];
InventoryItem.resourceNames = [
    {
        "singular": "inventory_item",
        "plural": "inventory_items"
    }
];
//# sourceMappingURL=inventory_item.js.map