"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.CancellationRequest = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class CancellationRequest extends base_1.Base {
    async accept({ message = null, body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "post",
            operation: "accept",
            session: this.session,
            urlIds: { "fulfillment_order_id": this.fulfillment_order_id },
            params: { "message": message, ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
    async reject({ message = null, body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "post",
            operation: "reject",
            session: this.session,
            urlIds: { "fulfillment_order_id": this.fulfillment_order_id },
            params: { "message": message, ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
}
exports.CancellationRequest = CancellationRequest;
CancellationRequest.apiVersion = types_1.ApiVersion.October23;
CancellationRequest.hasOne = {};
CancellationRequest.hasMany = {};
CancellationRequest.paths = [
    { "http_method": "post", "operation": "accept", "ids": ["fulfillment_order_id"], "path": "fulfillment_orders/<fulfillment_order_id>/cancellation_request/accept.json" },
    { "http_method": "post", "operation": "post", "ids": ["fulfillment_order_id"], "path": "fulfillment_orders/<fulfillment_order_id>/cancellation_request.json" },
    { "http_method": "post", "operation": "reject", "ids": ["fulfillment_order_id"], "path": "fulfillment_orders/<fulfillment_order_id>/cancellation_request/reject.json" }
];
CancellationRequest.resourceNames = [
    {
        "singular": "cancellation_request",
        "plural": "cancellation_requests"
    }
];
//# sourceMappingURL=cancellation_request.js.map