"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderRisk = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class OrderRisk extends base_1.Base {
    static getJsonBodyName() {
        return "risk";
    }
    static async find({ session, id, order_id = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id, "order_id": order_id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id, order_id = null }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id, "order_id": order_id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, order_id = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "order_id": order_id },
            params: { ...otherArgs },
        });
        return response;
    }
}
exports.OrderRisk = OrderRisk;
OrderRisk.apiVersion = types_1.ApiVersion.January24;
OrderRisk.hasOne = {};
OrderRisk.hasMany = {};
OrderRisk.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["order_id", "id"], "path": "orders/<order_id>/risks/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": ["order_id"], "path": "orders/<order_id>/risks.json" },
    { "http_method": "get", "operation": "get", "ids": ["order_id", "id"], "path": "orders/<order_id>/risks/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": ["order_id"], "path": "orders/<order_id>/risks.json" },
    { "http_method": "put", "operation": "put", "ids": ["order_id", "id"], "path": "orders/<order_id>/risks/<id>.json" }
];
OrderRisk.resourceNames = [
    {
        "singular": "risk",
        "plural": "risks"
    }
];
//# sourceMappingURL=order_risk.js.map