"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Theme = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class Theme extends base_1.Base {
    static async find({ session, id, fields = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, fields = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "fields": fields, ...otherArgs },
        });
        return response;
    }
}
exports.Theme = Theme;
Theme.apiVersion = types_1.ApiVersion.January24;
Theme.hasOne = {};
Theme.hasMany = {};
Theme.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "themes/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "themes.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "themes/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "themes.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "themes/<id>.json" }
];
Theme.resourceNames = [
    {
        "singular": "theme",
        "plural": "themes"
    }
];
//# sourceMappingURL=theme.js.map