"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transaction = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class Transaction extends base_1.Base {
    static async find({ session, id, order_id = null, fields = null, in_shop_currency = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id, "order_id": order_id },
            params: { "fields": fields, "in_shop_currency": in_shop_currency },
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, order_id = null, since_id = null, fields = null, in_shop_currency = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "order_id": order_id },
            params: { "since_id": since_id, "fields": fields, "in_shop_currency": in_shop_currency, ...otherArgs },
        });
        return response;
    }
    static async count({ session, order_id = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "count",
            session: session,
            urlIds: { "order_id": order_id },
            params: { ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.Transaction = Transaction;
Transaction.apiVersion = types_1.ApiVersion.January24;
Transaction.hasOne = {};
Transaction.hasMany = {};
Transaction.paths = [
    { "http_method": "get", "operation": "count", "ids": ["order_id"], "path": "orders/<order_id>/transactions/count.json" },
    { "http_method": "get", "operation": "get", "ids": ["order_id"], "path": "orders/<order_id>/transactions.json" },
    { "http_method": "get", "operation": "get", "ids": ["order_id", "id"], "path": "orders/<order_id>/transactions/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": ["order_id"], "path": "orders/<order_id>/transactions.json" }
];
Transaction.resourceNames = [
    {
        "singular": "transaction",
        "plural": "transactions"
    }
];
//# sourceMappingURL=transaction.js.map