import { BillingInterval, LATEST_API_VERSION } from "@shopify/shopify-api";
import { shopifyApp } from "@shopify/shopify-app-express";
import { SQLiteSessionStorage } from "@shopify/shopify-app-session-storage-sqlite";
import { restResources } from "@shopify/shopify-api/rest/admin/2024-04";

const DB_PATH = `${process.cwd()}/database.sqlite`;

// The transactions with Shopify will always be marked as test transactions, unless NODE_ENV is production.
// See the ensureBilling helper to learn more about billing in this template.
const billingConfig = {
  "My Shopify One-Time Charge": {
    // This is an example configuration that would do a one-time charge for $5 (only USD is currently supported)
    amount: 5.0,
    currencyCode: "USD",
    interval: BillingInterval.OneTime,
  },
};

const SHOPIFY_API_KEY = "95a64a43d4183d39730abe29c7985963";
const SHOPIFY_API_SECRET_KEY = "3a411ede44cf260ff4d74314b934817d";
const SHOPIFY_HOSTNAME = "juli-appstore-dev.myshopify.com";
const SHOPIFY_SCOPES = ['read_cart_transforms','read_checkouts','read_orders','read_products','write_cart_transforms','write_checkouts','write_orders','write_products']; // Add necessary scopes for your application

// console.log('restResources : ',restResources);
const shopify = shopifyApp({
  api: {
    apiKey: SHOPIFY_API_KEY,
    apiSecretKey: SHOPIFY_API_SECRET_KEY,
    hostName: SHOPIFY_HOSTNAME,
    scopes: SHOPIFY_SCOPES,
    apiVersion: LATEST_API_VERSION,
    restResources,
    billing: undefined,// or replace with billingConfig above to enable example billing
  },
  auth: {
    path: "/api/auth",
    callbackPath: "/api/auth/callback",
  },
  webhooks: {
    path: "/api/webhooks",
  },
  // This should be replaced with your preferred storage strategy
  sessionStorage: new SQLiteSessionStorage(DB_PATH),
});

export default shopify;
