import {
  init_lib as init_lib2,
  lib_exports as lib_exports2
} from "./chunk-NR2A47S5.js";
import {
  init_lib,
  lib_exports
} from "./chunk-YVZEXJC5.js";
import {
  init_tslib_es6,
  tslib_es6_exports
} from "./chunk-7EOD6UUN.js";
import {
  __commonJS,
  __toCommonJS
} from "./chunk-2GTGKKMZ.js";

// ../../node_modules/@formatjs/intl-pluralrules/abstract/InitializePluralRules.js
var require_InitializePluralRules = __commonJS({
  "../../node_modules/@formatjs/intl-pluralrules/abstract/InitializePluralRules.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.InitializePluralRules = void 0;
    var ecma402_abstract_1 = (init_lib(), __toCommonJS(lib_exports));
    var intl_localematcher_1 = (init_lib2(), __toCommonJS(lib_exports2));
    function InitializePluralRules(pl, locales, options, _a) {
      var availableLocales = _a.availableLocales, relevantExtensionKeys = _a.relevantExtensionKeys, localeData = _a.localeData, getDefaultLocale = _a.getDefaultLocale, getInternalSlots = _a.getInternalSlots;
      var requestedLocales = (0, ecma402_abstract_1.CanonicalizeLocaleList)(locales);
      var opt = /* @__PURE__ */ Object.create(null);
      var opts = (0, ecma402_abstract_1.CoerceOptionsToObject)(options);
      var internalSlots = getInternalSlots(pl);
      internalSlots.initializedPluralRules = true;
      var matcher = (0, ecma402_abstract_1.GetOption)(opts, "localeMatcher", "string", ["best fit", "lookup"], "best fit");
      opt.localeMatcher = matcher;
      internalSlots.type = (0, ecma402_abstract_1.GetOption)(opts, "type", "string", ["cardinal", "ordinal"], "cardinal");
      (0, ecma402_abstract_1.SetNumberFormatDigitOptions)(internalSlots, opts, 0, 3, "standard");
      var r = (0, intl_localematcher_1.ResolveLocale)(availableLocales, requestedLocales, opt, relevantExtensionKeys, localeData, getDefaultLocale);
      internalSlots.locale = r.locale;
      return pl;
    }
    exports.InitializePluralRules = InitializePluralRules;
  }
});

// ../../node_modules/@formatjs/intl-pluralrules/abstract/GetOperands.js
var require_GetOperands = __commonJS({
  "../../node_modules/@formatjs/intl-pluralrules/abstract/GetOperands.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.GetOperands = void 0;
    var ecma402_abstract_1 = (init_lib(), __toCommonJS(lib_exports));
    function GetOperands(s) {
      (0, ecma402_abstract_1.invariant)(typeof s === "string", "GetOperands should have been called with a string");
      var n = (0, ecma402_abstract_1.ToNumber)(s);
      (0, ecma402_abstract_1.invariant)(isFinite(n), "n should be finite");
      var dp = s.indexOf(".");
      var iv;
      var f;
      var v;
      var fv = "";
      if (dp === -1) {
        iv = n;
        f = 0;
        v = 0;
      } else {
        iv = s.slice(0, dp);
        fv = s.slice(dp, s.length);
        f = (0, ecma402_abstract_1.ToNumber)(fv);
        v = fv.length;
      }
      var i = Math.abs((0, ecma402_abstract_1.ToNumber)(iv));
      var w;
      var t;
      if (f !== 0) {
        var ft = fv.replace(/0+$/, "");
        w = ft.length;
        t = (0, ecma402_abstract_1.ToNumber)(ft);
      } else {
        w = 0;
        t = 0;
      }
      return {
        Number: n,
        IntegerDigits: i,
        NumberOfFractionDigits: v,
        NumberOfFractionDigitsWithoutTrailing: w,
        FractionDigits: f,
        FractionDigitsWithoutTrailing: t
      };
    }
    exports.GetOperands = GetOperands;
  }
});

// ../../node_modules/@formatjs/intl-pluralrules/abstract/ResolvePlural.js
var require_ResolvePlural = __commonJS({
  "../../node_modules/@formatjs/intl-pluralrules/abstract/ResolvePlural.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ResolvePlural = void 0;
    var ecma402_abstract_1 = (init_lib(), __toCommonJS(lib_exports));
    var GetOperands_1 = require_GetOperands();
    function ResolvePlural(pl, n, _a) {
      var getInternalSlots = _a.getInternalSlots, PluralRuleSelect = _a.PluralRuleSelect;
      var internalSlots = getInternalSlots(pl);
      (0, ecma402_abstract_1.invariant)((0, ecma402_abstract_1.Type)(internalSlots) === "Object", "pl has to be an object");
      (0, ecma402_abstract_1.invariant)("initializedPluralRules" in internalSlots, "pluralrules must be initialized");
      (0, ecma402_abstract_1.invariant)((0, ecma402_abstract_1.Type)(n) === "Number", "n must be a number");
      if (!isFinite(n)) {
        return "other";
      }
      var locale = internalSlots.locale, type = internalSlots.type;
      var res = (0, ecma402_abstract_1.FormatNumericToString)(internalSlots, n);
      var s = res.formattedString;
      var operands = (0, GetOperands_1.GetOperands)(s);
      return PluralRuleSelect(locale, type, n, operands);
    }
    exports.ResolvePlural = ResolvePlural;
  }
});

// ../../node_modules/@formatjs/intl-pluralrules/get_internal_slots.js
var require_get_internal_slots = __commonJS({
  "../../node_modules/@formatjs/intl-pluralrules/get_internal_slots.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var internalSlotMap = /* @__PURE__ */ new WeakMap();
    function getInternalSlots(x) {
      var internalSlots = internalSlotMap.get(x);
      if (!internalSlots) {
        internalSlots = /* @__PURE__ */ Object.create(null);
        internalSlotMap.set(x, internalSlots);
      }
      return internalSlots;
    }
    exports.default = getInternalSlots;
  }
});

// ../../node_modules/@formatjs/intl-pluralrules/index.js
var require_intl_pluralrules = __commonJS({
  "../../node_modules/@formatjs/intl-pluralrules/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.PluralRules = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var ecma402_abstract_1 = (init_lib(), __toCommonJS(lib_exports));
    var InitializePluralRules_1 = require_InitializePluralRules();
    var ResolvePlural_1 = require_ResolvePlural();
    var get_internal_slots_1 = tslib_1.__importDefault(require_get_internal_slots());
    function validateInstance(instance, method) {
      if (!(instance instanceof PluralRules)) {
        throw new TypeError("Method Intl.PluralRules.prototype.".concat(method, " called on incompatible receiver ").concat(String(instance)));
      }
    }
    function PluralRuleSelect(locale, type, _n, _a) {
      var IntegerDigits = _a.IntegerDigits, NumberOfFractionDigits = _a.NumberOfFractionDigits, FractionDigits = _a.FractionDigits;
      return PluralRules.localeData[locale].fn(NumberOfFractionDigits ? "".concat(IntegerDigits, ".").concat(FractionDigits) : IntegerDigits, type === "ordinal");
    }
    var PluralRules = (
      /** @class */
      function() {
        function PluralRules2(locales, options) {
          var newTarget = this && this instanceof PluralRules2 ? this.constructor : void 0;
          if (!newTarget) {
            throw new TypeError("Intl.PluralRules must be called with 'new'");
          }
          return (0, InitializePluralRules_1.InitializePluralRules)(this, locales, options, {
            availableLocales: PluralRules2.availableLocales,
            relevantExtensionKeys: PluralRules2.relevantExtensionKeys,
            localeData: PluralRules2.localeData,
            getDefaultLocale: PluralRules2.getDefaultLocale,
            getInternalSlots: get_internal_slots_1.default
          });
        }
        PluralRules2.prototype.resolvedOptions = function() {
          validateInstance(this, "resolvedOptions");
          var opts = /* @__PURE__ */ Object.create(null);
          var internalSlots = (0, get_internal_slots_1.default)(this);
          opts.locale = internalSlots.locale;
          opts.type = internalSlots.type;
          [
            "minimumIntegerDigits",
            "minimumFractionDigits",
            "maximumFractionDigits",
            "minimumSignificantDigits",
            "maximumSignificantDigits"
          ].forEach(function(field) {
            var val = internalSlots[field];
            if (val !== void 0) {
              opts[field] = val;
            }
          });
          opts.pluralCategories = tslib_1.__spreadArray([], PluralRules2.localeData[opts.locale].categories[opts.type], true);
          return opts;
        };
        PluralRules2.prototype.select = function(val) {
          var pr = this;
          validateInstance(pr, "select");
          var n = (0, ecma402_abstract_1.ToNumber)(val);
          return (0, ResolvePlural_1.ResolvePlural)(pr, n, { getInternalSlots: get_internal_slots_1.default, PluralRuleSelect });
        };
        PluralRules2.prototype.toString = function() {
          return "[object Intl.PluralRules]";
        };
        PluralRules2.supportedLocalesOf = function(locales, options) {
          return (0, ecma402_abstract_1.SupportedLocales)(PluralRules2.availableLocales, (0, ecma402_abstract_1.CanonicalizeLocaleList)(locales), options);
        };
        PluralRules2.__addLocaleData = function() {
          var data = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            data[_i] = arguments[_i];
          }
          for (var _a = 0, data_1 = data; _a < data_1.length; _a++) {
            var _b = data_1[_a], d = _b.data, locale = _b.locale;
            PluralRules2.localeData[locale] = d;
            PluralRules2.availableLocales.add(locale);
            if (!PluralRules2.__defaultLocale) {
              PluralRules2.__defaultLocale = locale;
            }
          }
        };
        PluralRules2.getDefaultLocale = function() {
          return PluralRules2.__defaultLocale;
        };
        PluralRules2.localeData = {};
        PluralRules2.availableLocales = /* @__PURE__ */ new Set();
        PluralRules2.__defaultLocale = "";
        PluralRules2.relevantExtensionKeys = [];
        PluralRules2.polyfilled = true;
        return PluralRules2;
      }()
    );
    exports.PluralRules = PluralRules;
    try {
      if (typeof Symbol !== "undefined") {
        Object.defineProperty(PluralRules.prototype, Symbol.toStringTag, {
          value: "Intl.PluralRules",
          writable: false,
          enumerable: false,
          configurable: true
        });
      }
      try {
        Object.defineProperty(PluralRules, "length", {
          value: 0,
          writable: false,
          enumerable: false,
          configurable: true
        });
      } catch (error) {
      }
      Object.defineProperty(PluralRules.prototype.constructor, "length", {
        value: 0,
        writable: false,
        enumerable: false,
        configurable: true
      });
      Object.defineProperty(PluralRules.supportedLocalesOf, "length", {
        value: 1,
        writable: false,
        enumerable: false,
        configurable: true
      });
    } catch (ex) {
    }
  }
});

// ../../node_modules/@formatjs/intl-pluralrules/polyfill-force.js
var require_polyfill_force = __commonJS({
  "../../node_modules/@formatjs/intl-pluralrules/polyfill-force.js"(exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    var _1 = require_intl_pluralrules();
    Object.defineProperty(Intl, "PluralRules", {
      value: _1.PluralRules,
      writable: true,
      enumerable: false,
      configurable: true
    });
  }
});
export default require_polyfill_force();
//# sourceMappingURL=@formatjs_intl-pluralrules_polyfill-force.js.map
