import {
  Card,
  Page,
  Layout,
  TextContainer,
  Image,
  Stack,
  Link,
  Text,
  Select,
  TextField,
  Button,
} from "@shopify/polaris";
import { TitleBar } from "@shopify/app-bridge-react";
import { useTranslation, Trans } from "react-i18next";
import { useState, useCallback } from 'react';

import { trophyImage } from "../assets";

import { ProductsCard } from "../components";

export default function HomePage() {
  const [selected, setSelected] = useState('today');
  const [value, setValue] = useState('Email');

  const handleSelectChange = useCallback(
    (value) => setSelected(value),
    [],
  );

  const options = [
    { label: 'Today', value: 'today' },
    { label: 'Yesterday', value: 'yesterday' },
    { label: 'Last 7 days', value: 'lastWeek' },
  ];


  const handleChange = useCallback(
    (newValue) => setValue(newValue),
    [],
  );

  return (
    <Page narrowWidth>
      <TitleBar title="First Page" primaryAction={null} />
      <Layout>
        <Layout.Section>
          <Select
            label="Date range"
            options={options}
            onChange={handleSelectChange}
            value={selected}
          />
          <Select
            label="Date range"
            options={options}
            onChange={handleSelectChange}
            value={selected}
          />
          <TextField
            label="Store name"
            value={value}
            onChange={handleChange}
            autoComplete="off"
          />

          <Button size="large">Save Data</Button>
        </Layout.Section>
        <Layout.Section>
        </Layout.Section>
      </Layout>
    </Page>
  );
}
