import type { MetadataProperties } from '../types';
declare type FontFamilyAlias = 'sans' | 'mono';
export declare type FontSizeScale = '75' | '100' | '200' | '300' | '400' | '500' | '600' | '700';
export declare type FontLineHeightScale = '1' | '2' | '3' | '4' | '5' | '6' | '7';
export declare type FontWeightAlias = 'regular' | 'medium' | 'semibold' | 'bold';
export declare type FontTokenName = `font-family-${FontFamilyAlias}` | `font-size-${FontSizeScale}` | `font-weight-${FontWeightAlias}` | `font-line-height-${FontLineHeightScale}`;
export declare type FontTokenGroup = {
    [TokenName in FontTokenName]: string;
};
export declare const font: {
    [TokenName in FontTokenName]: MetadataProperties;
};
export {};
//# sourceMappingURL=font.d.ts.map