'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polarisTokens = require('@shopify/polaris-tokens');
var css = require('../../../../utilities/css.js');
var ActionList = require('../../ActionList.scss.js');
var focus = require('../../../../utilities/focus.js');
var useIsomorphicLayoutEffect = require('../../../../utilities/use-isomorphic-layout-effect.js');
var Badge = require('../../../Badge/Badge.js');
var Tooltip = require('../../../Tooltip/Tooltip.js');
var UnstyledLink = require('../../../UnstyledLink/UnstyledLink.js');
var HorizontalStack = require('../../../HorizontalStack/HorizontalStack.js');
var Icon = require('../../../Icon/Icon.js');
var Box = require('../../../Box/Box.js');
var Text = require('../../../Text/Text.js');
var Scrollable = require('../../../Scrollable/Scrollable.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function Item({
  id,
  badge,
  content,
  accessibilityLabel,
  helpText,
  url,
  onAction,
  onMouseEnter,
  icon,
  image,
  prefix,
  suffix,
  disabled,
  external,
  destructive,
  ellipsis,
  truncate,
  active,
  role
}) {
  const className = css.classNames(ActionList["default"].Item, disabled && ActionList["default"].disabled, destructive && ActionList["default"].destructive, active && ActionList["default"].active);
  let prefixMarkup = null;

  if (prefix) {
    prefixMarkup = /*#__PURE__*/React__default["default"].createElement("span", {
      className: ActionList["default"].Prefix
    }, prefix);
  } else if (icon) {
    prefixMarkup = /*#__PURE__*/React__default["default"].createElement("span", {
      className: ActionList["default"].Prefix
    }, /*#__PURE__*/React__default["default"].createElement(Icon.Icon, {
      source: icon
    }));
  } else if (image) {
    prefixMarkup = /*#__PURE__*/React__default["default"].createElement("span", {
      role: "presentation",
      className: ActionList["default"].Prefix,
      style: {
        backgroundImage: `url(${image}`
      }
    });
  }

  let contentText = content || '';

  if (truncate && content) {
    contentText = /*#__PURE__*/React__default["default"].createElement(TruncateText, null, content);
  } else if (ellipsis) {
    contentText = `${content}…`;
  }

  const contentMarkup = helpText ? /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, /*#__PURE__*/React__default["default"].createElement(Box.Box, null, contentText), /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    color: "subdued",
    as: "span"
  }, helpText)) : contentText;
  const badgeMarkup = badge && /*#__PURE__*/React__default["default"].createElement("span", {
    className: ActionList["default"].Suffix
  }, /*#__PURE__*/React__default["default"].createElement(Badge.Badge, {
    status: badge.status
  }, badge.content));
  const suffixMarkup = suffix && /*#__PURE__*/React__default["default"].createElement(Box.Box, null, /*#__PURE__*/React__default["default"].createElement("span", {
    className: ActionList["default"].Suffix
  }, suffix));
  const textMarkup = /*#__PURE__*/React__default["default"].createElement("span", {
    className: ActionList["default"].Text
  }, contentMarkup);
  const contentElement = /*#__PURE__*/React__default["default"].createElement(HorizontalStack.HorizontalStack, {
    blockAlign: "center",
    gap: "4",
    wrap: !truncate
  }, prefixMarkup, textMarkup, badgeMarkup, suffixMarkup);
  const scrollMarkup = active ? /*#__PURE__*/React__default["default"].createElement(Scrollable.Scrollable.ScrollTo, null) : null;
  const control = url ? /*#__PURE__*/React__default["default"].createElement(UnstyledLink.UnstyledLink, {
    id: id,
    url: disabled ? null : url,
    className: className,
    external: external,
    "aria-label": accessibilityLabel,
    onClick: disabled ? null : onAction,
    role: role
  }, contentElement) : /*#__PURE__*/React__default["default"].createElement("button", {
    id: id,
    type: "button",
    className: className,
    disabled: disabled,
    "aria-label": accessibilityLabel,
    onClick: onAction,
    onMouseUp: focus.handleMouseUpByBlurring,
    role: role,
    onMouseEnter: onMouseEnter
  }, contentElement);
  return /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, scrollMarkup, control);
}
const TruncateText = ({
  children
}) => {
  const textRef = React.useRef(null);
  const [isOverflowing, setIsOverflowing] = React.useState(false);
  useIsomorphicLayoutEffect.useIsomorphicLayoutEffect(() => {
    if (textRef.current) {
      setIsOverflowing(textRef.current.scrollWidth > textRef.current.offsetWidth);
    }
  }, [children]);
  const text = /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    as: "span",
    truncate: true
  }, /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    width: "100%",
    ref: textRef
  }, children));
  return isOverflowing ? /*#__PURE__*/React__default["default"].createElement(Tooltip.Tooltip, {
    zIndexOverride: Number(polarisTokens.zIndex['z-6']),
    preferredPosition: "above",
    hoverDelay: 1000,
    content: children
  }, /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    as: "span",
    truncate: true
  }, children)) : text;
};

exports.Item = Item;
exports.TruncateText = TruncateText;
