'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var Item = require('../Item/Item.js');
var Box = require('../../../Box/Box.js');
var Text = require('../../../Text/Text.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function Section({
  section,
  hasMultipleSections,
  isFirst,
  actionRole,
  onActionAnyItem
}) {
  const handleAction = itemOnAction => {
    return () => {
      if (itemOnAction) {
        itemOnAction();
      }

      if (onActionAnyItem) {
        onActionAnyItem();
      }
    };
  };

  const actionMarkup = section.items.map(({
    content,
    helpText,
    onAction,
    ...item
  }, index) => {
    return /*#__PURE__*/React__default["default"].createElement("li", {
      key: `${content}-${index}`,
      role: actionRole === 'menuitem' ? 'presentation' : undefined
    }, /*#__PURE__*/React__default["default"].createElement(Item.Item, Object.assign({
      content: content,
      helpText: helpText,
      role: actionRole,
      onAction: handleAction(onAction)
    }, item)));
  });
  let titleMarkup = null;

  if (section.title) {
    titleMarkup = typeof section.title === 'string' ? /*#__PURE__*/React__default["default"].createElement(Box.Box, {
      paddingBlockStart: "4",
      paddingInlineStart: "4",
      paddingBlockEnd: "2",
      paddingInlineEnd: "4"
    }, /*#__PURE__*/React__default["default"].createElement(Text.Text, {
      as: "p",
      variant: "headingXs"
    }, section.title)) : /*#__PURE__*/React__default["default"].createElement(Box.Box, {
      padding: "2"
    }, section.title);
  }

  let sectionRole;

  switch (actionRole) {
    case 'option':
      sectionRole = 'presentation';
      break;

    case 'menuitem':
      sectionRole = !hasMultipleSections ? 'menu' : 'presentation';
      break;

    default:
      sectionRole = undefined;
      break;
  }

  const sectionMarkup = /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, titleMarkup, /*#__PURE__*/React__default["default"].createElement(Box.Box, Object.assign({
    as: "ul",
    padding: "2"
  }, hasMultipleSections && {
    paddingBlockStart: '0'
  }, sectionRole && {
    role: sectionRole
  }, {
    tabIndex: !hasMultipleSections ? -1 : undefined
  }), actionMarkup));
  return hasMultipleSections ? /*#__PURE__*/React__default["default"].createElement(Box.Box, Object.assign({
    as: "li",
    role: "presentation",
    borderColor: "border-subdued"
  }, !isFirst && {
    borderBlockStartWidth: '1'
  }, !section.title && {
    paddingBlockStart: '2'
  }), sectionMarkup) : sectionMarkup;
}

exports.Section = Section;
