'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var colorTransformers = require('../../../../utilities/color-transformers.js');
var ColorPicker = require('../../ColorPicker.scss.js');
var utilities = require('./utilities.js');
var Slidable = require('../Slidable/Slidable.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

class AlphaPicker extends React.PureComponent {
  constructor(...args) {
    super(...args);
    this.state = {
      sliderHeight: 0,
      draggerHeight: 0
    };

    this.setSliderHeight = node => {
      if (node == null) {
        return;
      }

      this.setState({
        sliderHeight: node.clientHeight
      });

      if (process.env.NODE_ENV === 'development') {
        setTimeout(() => {
          this.setState({
            sliderHeight: node.clientHeight
          });
        }, 0);
      }
    };

    this.setDraggerHeight = height => {
      this.setState({
        draggerHeight: height
      });
    };

    this.handleChange = ({
      y
    }) => {
      const {
        onChange
      } = this.props;
      const {
        sliderHeight
      } = this.state;
      const alpha = utilities.alphaForDraggerY(y, sliderHeight);
      onChange(alpha);
    };
  }

  render() {
    const {
      color,
      alpha
    } = this.props;
    const {
      sliderHeight,
      draggerHeight
    } = this.state;
    const draggerY = utilities.calculateDraggerY(alpha, sliderHeight, draggerHeight);
    const background = alphaGradientForColor(color);
    return /*#__PURE__*/React__default["default"].createElement("div", {
      className: ColorPicker["default"].AlphaPicker,
      ref: this.setSliderHeight
    }, /*#__PURE__*/React__default["default"].createElement("div", {
      className: ColorPicker["default"].ColorLayer,
      style: {
        background
      }
    }), /*#__PURE__*/React__default["default"].createElement(Slidable.Slidable, {
      draggerY: draggerY,
      draggerX: 0,
      onChange: this.handleChange,
      onDraggerHeight: this.setDraggerHeight
    }));
  }

}

function alphaGradientForColor(color) {
  const {
    red,
    green,
    blue
  } = colorTransformers.hsbToRgb(color);
  const rgb = `${red}, ${green}, ${blue}`;
  return `linear-gradient(to top, rgba(${rgb}, 0) 18px, rgba(${rgb}, 1) calc(100% - 18px))`;
}

exports.AlphaPicker = AlphaPicker;
