'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var LegacyCard = require('../../LegacyCard.scss.js');
var LegacyStack = require('../../../LegacyStack/LegacyStack.js');
var ButtonGroup = require('../../../ButtonGroup/ButtonGroup.js');
var utils = require('../../../Button/utils.js');
var Text = require('../../../Text/Text.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function Header({
  children,
  title,
  actions
}) {
  const actionMarkup = actions ? /*#__PURE__*/React__default["default"].createElement(ButtonGroup.ButtonGroup, null, utils.buttonsFrom(actions, {
    plain: true
  })) : null;
  const titleMarkup = /*#__PURE__*/React.isValidElement(title) ? title : /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    variant: "headingMd",
    as: "h2"
  }, title);
  const headingMarkup = actionMarkup || children ? /*#__PURE__*/React__default["default"].createElement(LegacyStack.LegacyStack, {
    alignment: "baseline"
  }, /*#__PURE__*/React__default["default"].createElement(LegacyStack.LegacyStack.Item, {
    fill: true
  }, titleMarkup), actionMarkup, children) : titleMarkup;
  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: LegacyCard["default"].Header
  }, headingMarkup);
}

exports.Header = Header;
