'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../../../utilities/css.js');
var LegacyCard = require('../../LegacyCard.scss.js');
var ButtonGroup = require('../../../ButtonGroup/ButtonGroup.js');
var utils = require('../../../Button/utils.js');
var LegacyStack = require('../../../LegacyStack/LegacyStack.js');
var Text = require('../../../Text/Text.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function Section({
  children,
  title,
  subdued,
  flush,
  fullWidth,
  actions,
  hideOnPrint
}) {
  const className = css.classNames(LegacyCard["default"].Section, flush && LegacyCard["default"]['Section-flush'], subdued && LegacyCard["default"]['Section-subdued'], fullWidth && LegacyCard["default"]['Section-fullWidth'], hideOnPrint && LegacyCard["default"]['Section-hideOnPrint']);
  const actionMarkup = actions ? /*#__PURE__*/React__default["default"].createElement(ButtonGroup.ButtonGroup, null, utils.buttonsFrom(actions, {
    plain: true
  })) : null;
  const titleMarkup = typeof title === 'string' ? /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    variant: "headingSm",
    as: "h3"
  }, title) : title;
  const titleAreaMarkup = titleMarkup || actionMarkup ? /*#__PURE__*/React__default["default"].createElement("div", {
    className: LegacyCard["default"].SectionHeader
  }, actionMarkup ? /*#__PURE__*/React__default["default"].createElement(LegacyStack.LegacyStack, {
    alignment: "baseline"
  }, /*#__PURE__*/React__default["default"].createElement(LegacyStack.LegacyStack.Item, {
    fill: true
  }, titleMarkup), actionMarkup) : titleMarkup) : null;
  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: className
  }, titleAreaMarkup, children);
}

exports.Section = Section;
