import React from 'react';
import { Button } from './Button.js';

function buttonsFrom(actions, overrides = {}) {
  if (Array.isArray(actions)) {
    return actions.map((action, index) => buttonFrom(action, overrides, index));
  } else {
    const action = actions;
    return buttonFrom(action, overrides);
  }
}
function buttonFrom({
  content,
  onAction,
  ...action
}, overrides, key) {
  return /*#__PURE__*/React.createElement(Button, Object.assign({
    key: key,
    onClick: onAction
  }, action, overrides), content);
}

export { buttonFrom, buttonsFrom };
