import React from 'react';
import { HorizontalGrid } from '../../../HorizontalGrid/HorizontalGrid.js';
import { CloseButton } from '../CloseButton/CloseButton.js';
import { Box } from '../../../Box/Box.js';
import { HorizontalStack } from '../../../HorizontalStack/HorizontalStack.js';
import { Text } from '../../../Text/Text.js';

function Header({
  id,
  children,
  closing,
  titleHidden,
  onClose
}) {
  const titleHiddenMarkup = /*#__PURE__*/React.createElement(Box, {
    position: "absolute",
    insetInlineEnd: "0",
    zIndex: "1"
  }, /*#__PURE__*/React.createElement(HorizontalStack, {
    gap: "4",
    align: "end",
    blockAlign: "center"
  }, /*#__PURE__*/React.createElement(CloseButton, {
    titleHidden: titleHidden,
    onClick: onClose
  })));

  if (titleHidden || !children) {
    return titleHiddenMarkup;
  }

  return /*#__PURE__*/React.createElement(Box, {
    paddingBlockStart: "4",
    paddingBlockEnd: "4",
    paddingInlineStart: "5",
    paddingInlineEnd: "5",
    borderBlockEndWidth: "1",
    borderColor: "border-subdued"
  }, /*#__PURE__*/React.createElement(HorizontalGrid, {
    columns: {
      xs: '1fr auto'
    },
    gap: "4"
  }, /*#__PURE__*/React.createElement(HorizontalStack, {
    gap: "4",
    blockAlign: "center"
  }, /*#__PURE__*/React.createElement(Text, {
    id: id,
    as: "h2",
    variant: "headingLg",
    breakWord: true
  }, children)), /*#__PURE__*/React.createElement(CloseButton, {
    pressed: closing,
    titleHidden: titleHidden,
    onClick: onClose
  })));
}

export { Header };
