import React from 'react';
import { classNames, getResponsiveProps, sanitizeCustomProperties } from '../../utilities/css.js';
import styles from './VerticalStack.scss.js';

const VerticalStack = ({
  as = 'div',
  children,
  align,
  inlineAlign,
  gap,
  id,
  reverseOrder = false,
  ...restProps
}) => {
  const className = classNames(styles.VerticalStack, (as === 'ul' || as === 'ol') && styles.listReset, as === 'fieldset' && styles.fieldsetReset);
  const style = {
    '--pc-vertical-stack-align': align ? `${align}` : '',
    '--pc-vertical-stack-inline-align': inlineAlign ? `${inlineAlign}` : '',
    '--pc-vertical-stack-order': reverseOrder ? 'column-reverse' : 'column',
    ...getResponsiveProps('vertical-stack', 'gap', 'space', gap)
  };
  return /*#__PURE__*/React.createElement(as, {
    className,
    style: sanitizeCustomProperties(style),
    ...restProps
  }, children);
};

export { VerticalStack };
