"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cancel = void 0;
const admin_1 = require("../clients/admin");
const error_1 = require("../error");
const CANCEL_MUTATION = `
  mutation appSubscriptionCancel($id: ID!, $prorate: Boolean) {
    appSubscriptionCancel(id: $id, prorate: $prorate) {
      appSubscription {
        id
        name
        test
      }
      userErrors {
        field
        message
      }
    }
  }
`;
function cancel(config) {
    return async function (subscriptionInfo) {
        const { session, subscriptionId, prorate = true } = subscriptionInfo;
        const GraphqlClient = (0, admin_1.graphqlClientClass)({ config });
        const client = new GraphqlClient({ session });
        try {
            const response = await client.request(CANCEL_MUTATION, {
                variables: { id: subscriptionId, prorate },
            });
            if (response.data?.appSubscriptionCancel?.userErrors.length) {
                throw new error_1.BillingError({
                    message: 'Error while canceling a subscription',
                    errorData: response.data?.appSubscriptionCancel?.userErrors,
                });
            }
            return response.data?.appSubscriptionCancel?.appSubscription;
        }
        catch (error) {
            if (error instanceof error_1.GraphqlQueryError) {
                throw new error_1.BillingError({
                    message: error.message,
                    errorData: error.response?.errors,
                });
            }
            else {
                throw error;
            }
        }
    };
}
exports.cancel = cancel;
//# sourceMappingURL=cancel.js.map