"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.subscriptions = void 0;
const error_1 = require("../error");
const admin_1 = require("../clients/admin");
const SUBSCRIPTION_QUERY = `
query appSubscription {
  currentAppInstallation {
    activeSubscriptions {
      id
      name
      test
      lineItems {
        id
        plan {
          pricingDetails {
            ... on AppRecurringPricing {
              price {
                amount
                currencyCode
              }
              interval
              discount {
                durationLimitInIntervals
                remainingDurationInIntervals
                priceAfterDiscount {
                  amount
                }
                value {
                  ... on AppSubscriptionDiscountAmount {
                    amount {
                      amount
                      currencyCode
                    }
                  }
                  ... on AppSubscriptionDiscountPercentage {
                    percentage
                  }
                }
              }
            }
            ... on AppUsagePricing {
              balanceUsed {
                amount
                currencyCode
              }
              cappedAmount {
                amount
                currencyCode
              }
              terms
            }
          }
        }
      }
    }
  }
}
`;
function subscriptions(config) {
    return async function ({ session, }) {
        if (!config.billing) {
            throw new error_1.BillingError({
                message: 'Attempted to look for purchases without billing configs',
                errorData: [],
            });
        }
        const GraphqlClient = (0, admin_1.graphqlClientClass)({ config });
        const client = new GraphqlClient({ session });
        const response = await client.request(SUBSCRIPTION_QUERY);
        return response.data?.currentAppInstallation;
    };
}
exports.subscriptions = subscriptions;
//# sourceMappingURL=subscriptions.js.map