"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Customer = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const metafield_1 = require("./metafield");
class Customer extends base_1.Base {
    static async find({ session, id, fields = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, ids = null, since_id = null, created_at_min = null, created_at_max = null, updated_at_min = null, updated_at_max = null, limit = null, fields = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "ids": ids, "since_id": since_id, "created_at_min": created_at_min, "created_at_max": created_at_max, "updated_at_min": updated_at_min, "updated_at_max": updated_at_max, "limit": limit, "fields": fields, ...otherArgs },
        });
        return response;
    }
    static async count({ session, created_at_min = null, created_at_max = null, updated_at_min = null, updated_at_max = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "count",
            session: session,
            urlIds: {},
            params: { "created_at_min": created_at_min, "created_at_max": created_at_max, "updated_at_min": updated_at_min, "updated_at_max": updated_at_max, ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
    static async orders({ session, id, status = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "orders",
            session: session,
            urlIds: { "id": id },
            params: { "status": status, ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
    static async search({ session, order = null, query = null, limit = null, fields = null, returnFullResponse = false, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "search",
            session: session,
            urlIds: {},
            params: { "order": order, "query": query, "limit": limit, "fields": fields, ...otherArgs },
            body: {},
            entity: null,
        });
        return returnFullResponse ? response : response?.body;
    }
    async account_activation_url({ body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "post",
            operation: "account_activation_url",
            session: this.session,
            urlIds: { "id": this.id },
            params: { ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
    async send_invite({ body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "post",
            operation: "send_invite",
            session: this.session,
            urlIds: { "id": this.id },
            params: { ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
}
exports.Customer = Customer;
Customer.apiVersion = types_1.ApiVersion.October22;
Customer.hasOne = {
    "metafield": metafield_1.Metafield
};
Customer.hasMany = {};
Customer.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "customers/<id>.json" },
    { "http_method": "get", "operation": "count", "ids": [], "path": "customers/count.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "customers.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "customers/<id>.json" },
    { "http_method": "get", "operation": "orders", "ids": ["id"], "path": "customers/<id>/orders.json" },
    { "http_method": "get", "operation": "search", "ids": [], "path": "customers/search.json" },
    { "http_method": "post", "operation": "account_activation_url", "ids": ["id"], "path": "customers/<id>/account_activation_url.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "customers.json" },
    { "http_method": "post", "operation": "send_invite", "ids": ["id"], "path": "customers/<id>/send_invite.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "customers/<id>.json" }
];
Customer.resourceNames = [
    {
        "singular": "customer",
        "plural": "customers"
    }
];
//# sourceMappingURL=customer.js.map