"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationCredit = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const currency_1 = require("./currency");
class ApplicationCredit extends base_1.Base {
    static async find({ session, id, fields = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, fields = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "fields": fields, ...otherArgs },
        });
        return response;
    }
}
exports.ApplicationCredit = ApplicationCredit;
ApplicationCredit.apiVersion = types_1.ApiVersion.January23;
ApplicationCredit.hasOne = {
    "currency": currency_1.Currency
};
ApplicationCredit.hasMany = {};
ApplicationCredit.paths = [
    { "http_method": "get", "operation": "get", "ids": [], "path": "application_credits.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "application_credits/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "application_credits.json" }
];
ApplicationCredit.resourceNames = [
    {
        "singular": "application_credit",
        "plural": "application_credits"
    }
];
//# sourceMappingURL=application_credit.js.map