"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentGateway = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class PaymentGateway extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { ...otherArgs },
        });
        return response;
    }
}
exports.PaymentGateway = PaymentGateway;
PaymentGateway.apiVersion = types_1.ApiVersion.January23;
PaymentGateway.hasOne = {};
PaymentGateway.hasMany = {};
PaymentGateway.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "payment_gateways/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "payment_gateways.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "payment_gateways/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "payment_gateways.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "payment_gateways/<id>.json" }
];
PaymentGateway.resourceNames = [
    {
        "singular": "payment_gateway",
        "plural": "payment_gateways"
    }
];
//# sourceMappingURL=payment_gateway.js.map