"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Page = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const metafield_1 = require("./metafield");
class Page extends base_1.Base {
    static async find({ session, id, fields = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, limit = null, since_id = null, title = null, handle = null, created_at_min = null, created_at_max = null, updated_at_min = null, updated_at_max = null, published_at_min = null, published_at_max = null, fields = null, published_status = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "limit": limit, "since_id": since_id, "title": title, "handle": handle, "created_at_min": created_at_min, "created_at_max": created_at_max, "updated_at_min": updated_at_min, "updated_at_max": updated_at_max, "published_at_min": published_at_min, "published_at_max": published_at_max, "fields": fields, "published_status": published_status, ...otherArgs },
        });
        return response;
    }
    static async count({ session, title = null, created_at_min = null, created_at_max = null, updated_at_min = null, updated_at_max = null, published_at_min = null, published_at_max = null, published_status = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "count",
            session: session,
            urlIds: {},
            params: { "title": title, "created_at_min": created_at_min, "created_at_max": created_at_max, "updated_at_min": updated_at_min, "updated_at_max": updated_at_max, "published_at_min": published_at_min, "published_at_max": published_at_max, "published_status": published_status, ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.Page = Page;
Page.apiVersion = types_1.ApiVersion.April23;
Page.hasOne = {
    "metafield": metafield_1.Metafield
};
Page.hasMany = {};
Page.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "pages/<id>.json" },
    { "http_method": "get", "operation": "count", "ids": [], "path": "pages/count.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "pages.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "pages/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "pages.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "pages/<id>.json" }
];
Page.resourceNames = [
    {
        "singular": "page",
        "plural": "pages"
    }
];
//# sourceMappingURL=page.js.map