"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Payment = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const transaction_1 = require("./transaction");
const checkout_1 = require("./checkout");
class Payment extends base_1.Base {
    static async find({ session, id, checkout_id = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id, "checkout_id": checkout_id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, checkout_id = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "checkout_id": checkout_id },
            params: { ...otherArgs },
        });
        return response;
    }
    static async count({ session, checkout_id = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "count",
            session: session,
            urlIds: { "checkout_id": checkout_id },
            params: { ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.Payment = Payment;
Payment.apiVersion = types_1.ApiVersion.April23;
Payment.hasOne = {
    "transaction": transaction_1.Transaction,
    "checkout": checkout_1.Checkout
};
Payment.hasMany = {};
Payment.paths = [
    { "http_method": "get", "operation": "count", "ids": ["checkout_id"], "path": "checkouts/<checkout_id>/payments/count.json" },
    { "http_method": "get", "operation": "get", "ids": ["checkout_id"], "path": "checkouts/<checkout_id>/payments.json" },
    { "http_method": "get", "operation": "get", "ids": ["checkout_id", "id"], "path": "checkouts/<checkout_id>/payments/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": ["checkout_id"], "path": "checkouts/<checkout_id>/payments.json" }
];
Payment.resourceNames = [
    {
        "singular": "payment",
        "plural": "payments"
    }
];
//# sourceMappingURL=payment.js.map