"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Collection = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const image_1 = require("./image");
class Collection extends base_1.Base {
    static async find({ session, id, fields = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async products({ session, id, limit = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "products",
            session: session,
            urlIds: { "id": id },
            params: { "limit": limit, ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.Collection = Collection;
Collection.apiVersion = types_1.ApiVersion.July23;
Collection.hasOne = {
    "image": image_1.Image
};
Collection.hasMany = {};
Collection.paths = [
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "collections/<id>.json" },
    { "http_method": "get", "operation": "products", "ids": ["id"], "path": "collections/<id>/products.json" }
];
Collection.resourceNames = [
    {
        "singular": "collection",
        "plural": "collections"
    }
];
//# sourceMappingURL=collection.js.map