"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dispute = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class Dispute extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, since_id = null, last_id = null, status = null, initiated_at = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "since_id": since_id, "last_id": last_id, "status": status, "initiated_at": initiated_at, ...otherArgs },
        });
        return response;
    }
}
exports.Dispute = Dispute;
Dispute.apiVersion = types_1.ApiVersion.July23;
Dispute.hasOne = {};
Dispute.hasMany = {};
Dispute.paths = [
    { "http_method": "get", "operation": "get", "ids": [], "path": "shopify_payments/disputes.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "shopify_payments/disputes/<id>.json" }
];
Dispute.resourceNames = [
    {
        "singular": "dispute",
        "plural": "disputes"
    }
];
//# sourceMappingURL=dispute.js.map