"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.GiftCardAdjustment = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class GiftCardAdjustment extends base_1.Base {
    static getJsonBodyName() {
        return "adjustment";
    }
    static async find({ session, id, gift_card_id = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id, "gift_card_id": gift_card_id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, gift_card_id = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "gift_card_id": gift_card_id },
            params: { ...otherArgs },
        });
        return response;
    }
}
exports.GiftCardAdjustment = GiftCardAdjustment;
GiftCardAdjustment.apiVersion = types_1.ApiVersion.July23;
GiftCardAdjustment.hasOne = {};
GiftCardAdjustment.hasMany = {};
GiftCardAdjustment.paths = [
    { "http_method": "get", "operation": "get", "ids": ["gift_card_id"], "path": "gift_cards/<gift_card_id>/adjustments.json" },
    { "http_method": "get", "operation": "get", "ids": ["gift_card_id", "id"], "path": "gift_cards/<gift_card_id>/adjustments/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": ["gift_card_id"], "path": "gift_cards/<gift_card_id>/adjustments.json" }
];
GiftCardAdjustment.resourceNames = [
    {
        "singular": "gift_card_adjustment",
        "plural": "gift_card_adjustments"
    }
];
//# sourceMappingURL=gift_card_adjustment.js.map