"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductResourceFeedback = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class ProductResourceFeedback extends base_1.Base {
    static getJsonBodyName() {
        return "resource_feedback";
    }
    static async all({ session, product_id = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "product_id": product_id },
            params: { ...otherArgs },
        });
        return response;
    }
}
exports.ProductResourceFeedback = ProductResourceFeedback;
ProductResourceFeedback.apiVersion = types_1.ApiVersion.January24;
ProductResourceFeedback.hasOne = {};
ProductResourceFeedback.hasMany = {};
ProductResourceFeedback.paths = [
    { "http_method": "get", "operation": "get", "ids": ["product_id"], "path": "products/<product_id>/resource_feedback.json" },
    { "http_method": "post", "operation": "post", "ids": ["product_id"], "path": "products/<product_id>/resource_feedback.json" }
];
ProductResourceFeedback.resourceNames = [
    {
        "singular": "product_resource_feedback",
        "plural": "product_resource_feedbacks"
    }
];
//# sourceMappingURL=product_resource_feedback.js.map